#!/usr/bin/perl

# pred2.pl by Noah Vawter 7/25/2001
#
# this script reads in a list of pairs of PTCH setting and
# measured frequencies.  Then, it generates the PTCH settings to
# get all possible notes on the Western Equal Temp. Scale
# within the range of that instrument

$lowC=8.1758;  # love this number
@note=("C-","C#","D-","D#","E-","F-",
       "F#","G-","G#","A-","A#","B-");
$i=0;

$_=<>;
print $_;

while(<>)
{
    @spl=split(/\s+/,$_);
    $in [$i] = $spl[0];   # PTCH setting
    $out[$i] = $spl[1];   # Measured Freq.
    $i++;
}

# first and last...
$A=$out[0];
$B=$out[$i-1];

# find range of potential notes:
$high=0;
$low=128;
for($n=0;$n<128;$n++){
    $fr=freq($n);
 
#    print "fr=$fr\n";
    if( $fr < $A) { $low=$n; }
    if( $fr < $B) { $high=$n+1; }
}

$lowf=freq($low);
$highf=freq($high);

print "Measurements: Lowest Freq=$A Hz  Highest Freq=$B Hz\n";

print "Note\tperfect freq, MD PTCH setting, MD freq, accuracy\n";

# Loop through potential range, find closest MD PTCH setting
for($n=$low;$n<=$high;$n++)
{
    $freq=freq($n);

    $ptch=int(freq2ptch(freq($n)));

    $att_fr[0]=ptch2freq($ptch-1);  # do multiple to find closest
    $att_fr[1]=ptch2freq($ptch);
    $att_fr[2]=ptch2freq($ptch+1);

    for($dst=9999,$q=0;$q<=2;$q++){
	$att_dst=abs($att_fr[$q]-$freq);

#	print "att_dst=$att_dst\n";
	if (  $att_dst < $dst ){ $match=$q; $dst=$att_dst; }
    }
#    print "match=$match\n";
    $fr=$att_fr[$match];
    $ptch= $ptch -1 +$match;

    $err=100*($freq-$fr)/($freq);

    if( ($ptch>=0) && ($ptch<=127) )
    {
#	print "$n)";
	$oct=int($n/12);
	print $note[$n%12],"$oct\t";

	printf("%5.1fHz\t",$freq);

	printf("PTCH=%3d\tMDfreq=%5.1fHz\t",$ptch,$fr);
	printf("% 5.1f%%err",$err);
	print "\n";
    }
}

$predout=3;

# note 2 freq func
sub freq {
    $val=$lowC * 2**($_[0]/12);
    return($val);
}

# freq 2 PTCH func
sub freq2ptch {
    
    $val=log($_[0]/$A)/log($B/$A)*127;

    return($val);
}

# PTCH 2 freq func
sub ptch2freq {

    $val = $A * ($B/$A)**($_[0]/127);

    return($val);
}

#print "$i, $in, $out, $predout, percent err=$err\n";
#$i++;
