.module       MIDI;   { this is the good midi driver }

.include <system.k>;
.include <flash2.k>;

.global         process_midi;
.global inputmidi;

{ make things a little simpler }
.var    midi_vel,               { MIDI velocity }
        midi_note,              { MIDI note }
        midi_cont,              { MIDI controller number }
        midi_val;               { MIDI controller value }

{ variables for the MIDI input state machine }
.var    inputmidi,              { MIDI input data from serial port }
        midi_status,midi_ch,    { MIDI Status, MIDI channel }
        midi_state,             { MIDI state machine }
        midi_data1,midi_data2,  { incoming midi data }
        midi_sysexmode;         { are we in sysex mode 0/1 }

.init midi_state:       0x0;
.init midi_status:      0x0;
.init midi_sysexmode:   0x0;

{ let the cartooooooooons, begin! -------------------------------------- }
process_midi:   

        { read incoming byte }
        i4 = dm (PTR_TO_GET_CHAR);
        call (i4);
        if lt jump end_proc_midi; { time out }

        ax1 = dm(midi_sysexmode);
        ay1 = 0xf0;
        ar  = ay1-ax1;
        if eq jump MIDIsysex_end;       { check for end of sysex message }
        ar  = tstbit 0 of ax1;
        if ne jump MIDIsysex_word;      { if in sysex mode, skip normal processing }

        dm(inputmidi) = ax1;
        ar = tstbit 7 of ax1;
        if ne jump MIDIstatus;

MIDIdata:
        { shift MIDI data in }
        ax0 = dm(midi_data2);
        dm(midi_data1) = ax0;
        dm(midi_data2) = ax1;

        ar  = dm(midi_state);
        none = pass ar;
        if ne jump MIDIevent;

        ax1 = 1;                { wait for another byte }
        dm(midi_state)=ax1;
        jump end_proc_midi;


MIDIevent:
        ax1 = 0;                  { initialize input data buffer }
        dm(midi_state)=ax1;

        ax1 = dm(midi_status);

        { look for MIDI note on messages }
        ay0 = 0x0090;{ note on =1001xxxx} none = ax1 - ay0;if eq jump MIDInoteon;

        { look for MIDI note off messages }
        ay0 = 0x0080;{ note on =1000xxxx} none = ax1 - ay0;if eq jump MIDInoteoff;

        { look for MIDI Controller messages on any channel }
        ay0 = 0x00b0;{ control =1011xxxx} none = ax1 - ay0;if eq jump MIDIcontr;

        { ignore other types of messages (for now!) }
        jump end_proc_midi;

MIDIstatus:
        ay0 = 0xf0;
        ar  = ax1 and ay0;        { check for an F in upper nybble }         
        ar  = ar - ay0;
        if eq jump MIDIrealtime;

        dm(midi_status)=ax1;      { set this as our new status }

        ax1 = 0;                  { initialize input data buffer }
        dm(midi_state)=ax1;

        ay1 = dm(midi_status);    { compute midi channel number }
        ax1 = 0x000f;
        ar  = ax1 and ay1;
        dm(midi_ch) = ar;               

        jump end_proc_midi;


{ ax1 = [f0,f1,f2,f3,f4,f5,f6,f7,f8,f9,fa,fb,fc,fd,fe,ff] }
MIDIrealtime:

        { transport lovelies }                                                                        
        ay0 = 0x00FA;{ start } none = ax1 - ay0;if eq jump handleMIDIstart;
        ay0 = 0x00FB;{ cont  } none = ax1 - ay0;if eq jump handleMIDIcont;
        ay0 = 0x00FC;{ stop  } none = ax1 - ay0;if eq jump handleMIDIstop;
        ay0 = 0x00F8;{ clock } none = ax1 - ay0;if eq jump handleMIDIclock;

        { sysex }
        ay0 = 0x00F0;{ start } none = ax1 - ay0;if eq jump MIDIsysex_begin;
        ay0 = 0x00F7;{ start } none = ax1 - ay0;if eq jump MIDIsysex_end;


        jump end_proc_midi;

{ handle MIDI Note on message --------------------------------------- }
MIDInoteon:         
        ax0 = dm(midi_data1);           { get midi_note number }
        dm(midi_note) = ax1;

        ax1 = dm(midi_data2);           { get midi_vel value }
        dm(midi_vel) = ax1;

        call handleMIDInoteon;          { update syn_delta according to new note }

        jump end_proc_midi;

{ handle MIDI Note Off message --------------------------------------- }
MIDInoteoff:
        ax0 = dm(midi_data1);           { get midi_note number }
        dm(midi_note) = ax0;

        ax1 = dm(midi_data2);           { get midi_vel value }
        dm(midi_vel) = ax1;

        call handleMIDInoteoff;         { update envelope status }

        jump end_proc_midi;

{ handle MIDI Control message ------------------------------------ }
MIDIcontr:

        ax0 = dm(midi_data1);           { get midi_cont number }
        dm(midi_cont) = ax0;

        ax1 = dm(midi_data2);           { get midi_val value }
        dm(midi_val) = ax1;

        { jump to appropriate routine for controller type }
        call handleMIDIcontr;

        jump end_proc_midi;

MIDIsysex_begin:
        ar  = 1;
        dm(MIDI_sysexmode) = ar;

        call handleMIDIsysex_begin;

        jump end_proc_midi;

MIDIsysex_end:
        ar  = 0;
        dm(MIDI_sysexmode) = ar;
        call handleMIDIsysex_end;
        jump end_proc_midi;

MIDIsysex_word:
        call handleMIDIsysex_word;
        jump end_proc_midi;

end_proc_midi:
        rts;

.endmod;

