.module/RAM/ABS=0 initme;


.include    <system.k>;

.global         nSend;
.external       process_midi;
.external       inputmidi;


{ Variables }

.var/dm/ram signon [81];

.init signon:
'r','e','m','i','x','e','r',0;

.var input1,input2,output1,output2;

{ codec driver variables }

.var/dm/ram/circ                rx_buf[3];      { Status + L data + R data }
.var/dm/ram/circ                tx_buf[3];      { Cmd + L data + R data    }
.var/dm/ram/circ                init_cmds[13];
.var/dm                         stat_flag;

.init tx_buf:   0xc000, 0x0000, 0x0000; { Initially set MCE        }

.init init_cmds:0xc002,0xc102,0xc288,0xc388,0xc488,0xc588,0xc680,0xc780,
                0xc850,0xc909,0xca00,0xcc40,0xcd00;

{ bpm = 120; }
.var notelen;
{ .init notelen = 240/120*5513/16; }
.init notelen:800;


.var countdown;
.init countdown:0;

{ 8 possible segments, 16th notes }
.var seqstep;
.init seqstep:15;  { counts backwards for programming ease }
.var segseq[16];
.init segseq[0]: 5,4,5,4, 5,4,5,4, 3,2,1,0, 3,0,5,0;
.var segaddr[8];

.const MAINBUFSIZE=7000;
.var/dm/circ mainbuf[MAINBUFSIZE];
.var writeptr;
.init writeptr:^mainbuf;
.var readidx;
.init readidx:0;



{ Interrupt vector table }
        jump start;  rti; rti; rti;     {00: reset }
        rti;         rti; rti; rti;     {04: IRQ2 }
        rti;         rti; rti; rti;     {08: IRQL1 }
        rti;         rti; rti; rti;     {0c: IRQL0 }
        ar = dm(stat_flag);             {10: SPORT0 tx }
        ar = pass ar;
        if eq rti;
        jump next_cmd;
        jump input_samples;             {14: SPORT1 rx }
                     rti; rti; rti;
        rti;         rti; rti; rti;     {18: IRQE }
        rti;         rti; rti; rti;     {1c: BDMA }
        jump irq1isr;rti; rti; rti;     {20: SPORT1 tx or IRQ1 }
        rti;         rti; rti; rti;     {24: SPORT1 rx or IRQ0 }
        rti;         rti; rti; rti;     {28: timer }
        rti;         rti; rti; rti;     {2c: power down }


{ ADSP 2181 intialization }

start:
        m7 = 0;
        l7 = 0;
        ax0 = b#0000100000000000;
        dm (System_Control_Reg) = ax0;          { shut down sport 0 }

        i7 = 0x3fe8;            { restore monitor timer handler }
        ar = pm (i7, m7);       { px implicit }
        i7 = 0x28;
        pm (i7, m7) = ar;

        i5 = ^rx_buf;l5 = %rx_buf;
        i6 = ^tx_buf;l6 = %tx_buf;
        i3 = ^init_cmds;l3 = %init_cmds;
        m1 = 1;m5 = 1;

{================== S E R I A L   P O R T   #0   S T U F F ==================}
        ax0 = b#0000110011010111;   dm (SPORT0_Autobuf) = ax0;
        ax0 = 0;    dm (SPORT0_RFSDIV) = ax0;
        ax0 = 0;    dm (SPORT0_SCLKDIV) = ax0;
        ax0 = b#1000011000001111;   dm (SPORT0_Control_Reg) = ax0;
        ax0 = b#0000000000000111;   dm (SPORT0_TX_Channels0) = ax0;
        ax0 = b#0000000000000111;   dm (SPORT0_TX_Channels1) = ax0;
        ax0 = b#0000000000000111;   dm (SPORT0_RX_Channels0) = ax0;
        ax0 = b#0000000000000111;   dm (SPORT0_RX_Channels1) = ax0;

{============== S Y S T E M   A N D   M E M O R Y   S T U F F ==============}
        ax0 = b#0001100000000000;   dm (System_Control_Reg) = ax0;
        ifc = b#00000011111111;         { clear pending interrupt }
        nop;

        icntl = b#00010;
        mstat = b#1000000;

        { ADSP 1847 Codec intialization }
        ax0 = 1;
        dm(stat_flag) = ax0;            { clear flag }
        ena ints;                       { enable transmit interrupt }
        imask = b#0001000000;
        ax0 = dm (i6, m5);              { start interrupt }
        tx0 = ax0;

check_init:
        ax0 = dm (stat_flag);       { wait for entire init }
        af = pass ax0;              { buffer to be sent to }
        if ne jump check_init;      { the codec            }

        ay0 = 2;
check_aci1:
        ax0 = dm (rx_buf);          { once initialized, wait for codec }
        ar = ax0 and ay0;           { to come out of autocalibration }
        if eq jump check_aci1;      { wait for bit set }

check_aci2:
        ax0 = dm (rx_buf);          { wait for bit clear }
        ar = ax0 and ay0;
        if ne jump check_aci2;
        idle;

        ay0 = 0xbf3f;               { unmute left DAC }
        ax0 = dm (init_cmds + 6);
        ar = ax0 AND ay0;
        dm (tx_buf) = ar;
        idle;

        ax0 = dm (init_cmds + 7);   { unmute right DAC }
        ar = ax0 AND ay0;
        dm (tx_buf) = ar;
        idle;
        ifc = b#00000011111111;     { clear any pending interrupt }
        nop;

        l0=0; l1=0; l2=0; l3=0; l4=0; l7=0;

        imask = b#0000100101;       { enable rx0 interrupt }

        i7 = ^signon;
        call sendLine;              { send line to host }

        { set up PF0-PF3 }
        ay1 = dm(PFTYPE);
        ax1 = 0xFFF0;
        ar  = ax1 and ay1;
        dm(PFTYPE) = ar;

        { bus settle ? }
        nop;
        nop;
        call gensegs;
        
        jump main_loop;

{ command loop - check for incoming data on serial port }

main_loop:  
        ar = dm (CHAR_WAITING_FLAG);            { kbhit () }
        none = pass ar;
        if ne jump main_loop;
        rts;


        { call process_midi;            }  { has something }

        jump main_loop;



gensegs:
        cntr = 8;
        ar  = 0;
        ay0 = dm(notelen);
        i1  = ^segaddr;
        m1  = 1;
        l1  = 0;

do gensegloop until ce;
        dm(i1,m1) = ar;
        ar  = ar + ay0;
gensegloop:
        nop;

        rts;



{ SPORT0 interrupt handler  (called at 8Khz) }
input_samples:

        ena sec_reg;
        
        ax0 = dm(rx_buf + 1);
        ay0 = dm(rx_buf + 2);
        ar  = ax0 + ay0;

        { record data }
        ay0 = dm(writeptr);
        i0  = ay0;
        m1  = 1;
        l0  = MAINBUFSIZE;
        dm(i0,m1) = ar;
        ar  = i0;
        dm(writeptr) = ar;

        { playback }
        ax0 = ^mainbuf;
        ay0 = dm(readidx);
        ar  = ax0 + ay0;
        i0  = ar;
        mx0 = dm(i0,m1);
        dm(tx_buf + 1) = mx0;
        dm(tx_buf + 2) = mx0;
        ar  = ay0 + 1;
        ay0 = MAINBUFSIZE;
        none = ar - ay0;
        if  lt jump readidxokay;
        ar  = 0;
readidxokay:
        dm(readidx) = ar;

        { sequence abrupt readidx shift }
        ar  = dm(countdown);
        ar  = ar - 1;
        dm(countdown) = ar;
        if gt jump seqdone;
        ar  = dm(notelen);
        dm(countdown) = ar;

        ar  = dm(seqstep);
        ar  = ar - 1;
        dm(seqstep) = ar;
        if gt jump seqstepokay;
        ar  = 15;
        dm(seqstep) = ar;
seqstepokay:

        ay0 = ^segseq;
        ar  = ar + ay0;
        i0  = ar;
        ay0 = dm(i0,m0);  { okay, we're on this step }
        ax0 = i0;

        ar  = ^segaddr;
        ar  = ar + ay0;
        i0  = ar;
        ay0 = dm(i0,m0);
        dm(readidx) = ay0;    { sync the read pointer }

        { munge }
        ar  = dm(rx_buf +1);
        ay0 = 0xf;
        ar  = ar and ay0;
        i0  = ax0;
        dm(i0,m0) = ar;

seqdone:

        rti;


copout:
        ax0 = dm(rx_buf + 1);
        ay0 = dm(rx_buf + 2);
        dm(tx_buf + 1) = ax0;
        dm(tx_buf + 2) = ay0;

        rti;

        
{ transmit interrupt used for Codec initialization }
next_cmd:
        ena sec_reg;
        ax0 = dm (i3, m1);          { fetch next control word and }
        dm (tx_buf) = ax0;          { place in transmit slot 0    }
        ax0 = i3;
        ay0 = ^init_cmds;
        ar = ax0 - ay0;
        if gt rti;                  { rti if more control words still waiting }
        ax0 = 0xaf00;               { else set done flag and }
        dm (tx_buf) = ax0;          { remove MCE if done initialization }
        ax0 = 0;
        dm (stat_flag) = ax0;       { reset status flag }
        rti;

{ MIDI serial port ISR - actually just enables timer, which
  calls timer interrupt to read the serial port }
irq1isr:
        pop sts;
        ena timer;              { start timer now }
        rts;                    { note rts }

nSend:  {rts;}
        i4 = dm (PTR_TO_OUT_CHAR);        { send int }
        call (i4);

nwt:
        ar = dm (CHAR_SEND_DONE_FLAG);
        none = pass ar;
        if eq jump nwt;                 { wait for char to go out }

        rts;

.entry      sendLine;




{******************************************************************************
 *
 *  Send null terminated string pointed to by i7 and LF/CR.  ASCII is in
 *  lower 8-bit.
 *
 *  REGISTER USAGE SUMMARY:
 *
 *  input  : i7
 *  modyfy : none
 *  output : none
 *  destroy: i7, m7 = 1, l7 = 0, ax1
 *  keep   : none
 *  memory : out_char_ax1
 *  calls  : none
 *
 ******************************************************************************}

sendLine:
        l7 = 0;
        m7 = 1;
again:
        ax1 = dm (i7, m7);
        none = pass ax1;
        if eq jump linefeed;
        call nSend;
        jump again;

linefeed:
{        ax1 = 13;
        call nSend;
        ax1 = 10;
        call nSend;
}
        rts;

.endmod;
