.module/RAM/ABS=0       EFFECT;

{ Right now this program lives in its interrupt handler...
  Perhaps this accounts for some of its instability?
  Codec interrupt has higher priority?
  Serial Interrupt should disable interrupts?

  Note also this file is an entire effect, urm, this need
  not be here...Naturally all the flash stuff would make
  for a nice addition to the newmon anyway.
}

.CONST SETTINGS=16;
.CONST MAXBRAINSIZE=4096;

.include    <system.k>;

.global         nSend;
.external       process_midi;

.external       inputmidi;


.external wave_squ;

.global cur_setting;
.global brain_delta_hi,brain_delta_lo,delta_hi,delta_lo;
.global cur_write_setting;
.global volume,cur_volume;
.global dry_volume,cur_dry_volume; 
.global reverse,cur_reverse;
.global distortion,cur_distortion;
.global sample,cur_sample;
.global retrigger,cur_retrigger,brain_pos_hi,brain_pos_lo;
.global effectfb,cur_effectfb;
.global inplevel,cur_inplevel;
.global portamento,cur_portamento,porta_step;
.global target_delta_hi,target_delta_lo;
.global brain_size,cur_brain_size;
.global decay,cur_decay,decay_step,decay_level;
.global pan_l,pan_r,cur_l_pan,cur_r_pan;
.global inp_source,cur_inp_source;
.global mod_wave_delta,mod_wave_ptr,mod_deltas;

{ Variables }

.var/dm/ram signon [81];

.init signon:
'F','l','a','s','h','e','r',0;

.var
    input1,input2,output1,output2,
    brain_write_pos,
    brain_pos_hi,brain_pos_lo,
    brain_delta_hi,brain_delta_lo,
    cur_volume,
    cur_setting,
    cur_write_setting,
    cur_dry_volume,
    cur_reverse,
    cur_distortion,
    cur_sample,
    cur_retrigger,
    cur_effectfb,
    cur_inplevel,
    cur_portamento,porta_step,target_delta_hi,target_delta_lo,
    cur_delta,
    cur_brain_size,
    cur_decay,decay_level,decay_step,
    cur_l_pan,cur_r_pan,
    cur_inp_source,
    mod_wave_delta,mod_wave_phase,mod_wave_ptr;


.init   brain_write_pos:0x0;   
.init   brain_pos_hi:   0x0;
.init   brain_pos_lo:   0x0;
.init   brain_delta_hi: 0x1;
.init   brain_delta_lo: 0x0;
.init   cur_volume:     0x7fff;
.init   cur_setting:    0x0;
.init   cur_write_setting:      0x0;
.init   cur_dry_volume: 0x0000;
.init   cur_reverse:    0x0;
.init   cur_distortion: 0x0800;
.init   cur_sample:     0x1;
.init   cur_retrigger:  0x0;
.init   cur_effectfb:   0x0;
.init   cur_inplevel:   0x7fff;
.init   cur_portamento: 0x0001;
.init   porta_step:     0x0001;
.init   target_delta_hi:0x1;
.init   target_delta_lo:0x0;
.init   cur_brain_size: 0x0fff;
.init   cur_decay:      0x0000;
.init   decay_level:    0x7fff;
.init   decay_step:     0x0100;
.init   cur_l_pan:      0x7fff;
.init   cur_r_pan:      0x0000;
.init   cur_inp_source: 0x01;
.init   mod_wave_delta: 0x0000;
.init   mod_wave_phase: 0x0000;
.init   mod_wave_ptr:   ^wave_squ;

{ Setting data }

.var    delta_hi[SETTINGS],delta_lo[SETTINGS];
.var    volume[SETTINGS];
.var    dry_volume[SETTINGS];
.var    reverse[SETTINGS];
.var    distortion[SETTINGS];
.var    sample[SETTINGS];
.var    retrigger[SETTINGS];
.var    effectfb[SETTINGS];
.var    inplevel[SETTINGS];
.var    portamento[SETTINGS];
.var    brain_size[SETTINGS];
.var    decay[SETTINGS];
.var    pan_l[SETTINGS];
.var    pan_r[SETTINGS];
.var    inp_source[SETTINGS];
.var    mod_deltas[SETTINGS];

.var/dm/ram/circ                rx_buf[3];      { Status + L data + R data }
.var/dm/ram/circ                tx_buf[3];      { Cmd + L data + R data    }
.var/dm/ram/circ                init_cmds[13];
.var/dm                         stat_flag;
.var/dm/ram/circ                brain[MAXBRAINSIZE];    { main audio buffer }

.init tx_buf:   0xc000, 0x0000, 0x0000; { Initially set MCE        }

.init init_cmds:0xc002,0xc102,0xc288,0xc388,0xc488,0xc588,0xc680,0xc780,
                0xc850,0xc909,0xca00,0xcc40,0xcd00;

{ Interrupt vector table }
        jump start;  rti; rti; rti;     {00: reset }
        rti;         rti; rti; rti;     {04: IRQ2 }
        rti;         rti; rti; rti;     {08: IRQL1 }
        rti;         rti; rti; rti;     {0c: IRQL0 }
        ar = dm(stat_flag);             {10: SPORT0 tx }
        ar = pass ar;
        if eq rti;
        jump next_cmd;
        jump input_samples;             {14: SPORT1 rx }
                     rti; rti; rti;
        rti;         rti; rti; rti;     {18: IRQE }
        rti;         rti; rti; rti;     {1c: BDMA }
        jump irq1isr;rti; rti; rti;     {20: SPORT1 tx or IRQ1 }
        rti;         rti; rti; rti;     {24: SPORT1 rx or IRQ0 }
        rti;         rti; rti; rti;     {28: timer }
        rti;         rti; rti; rti;     {2c: power down }


{ ADSP 2181 intialization }

start:
        m7 = 0;
        l7 = 0;
        ax0 = b#0000100000000000;
        dm (System_Control_Reg) = ax0;          { shut down sport 0 }

        i7 = 0x3fe8;            { restore monitor timer handler }
        ar = pm (i7, m7);       { px implicit }
        i7 = 0x28;
        pm (i7, m7) = ar;

        i5 = ^rx_buf;l5 = %rx_buf;
        i6 = ^tx_buf;l6 = %tx_buf;
        i3 = ^init_cmds;l3 = %init_cmds;
        m1 = 1;m5 = 1;

{================== S E R I A L   P O R T   #0   S T U F F ==================}
        ax0 = b#0000110011010111;   dm (SPORT0_Autobuf) = ax0;
        ax0 = 0;    dm (SPORT0_RFSDIV) = ax0;
        ax0 = 0;    dm (SPORT0_SCLKDIV) = ax0;
        ax0 = b#1000011000001111;   dm (SPORT0_Control_Reg) = ax0;
        ax0 = b#0000000000000111;   dm (SPORT0_TX_Channels0) = ax0;
        ax0 = b#0000000000000111;   dm (SPORT0_TX_Channels1) = ax0;
        ax0 = b#0000000000000111;   dm (SPORT0_RX_Channels0) = ax0;
        ax0 = b#0000000000000111;   dm (SPORT0_RX_Channels1) = ax0;

{============== S Y S T E M   A N D   M E M O R Y   S T U F F ==============}
        ax0 = b#0001100000000000;   dm (System_Control_Reg) = ax0;
        ifc = b#00000011111111;         { clear pending interrupt }
        nop;

        icntl = b#00010;
        mstat = b#1000000;

        { ADSP 1847 Codec intialization }
        ax0 = 1;
        dm(stat_flag) = ax0;            { clear flag }
        ena ints;                       { enable transmit interrupt }
        imask = b#0001000000;
        ax0 = dm (i6, m5);              { start interrupt }
        tx0 = ax0;

check_init:
        ax0 = dm (stat_flag);       { wait for entire init }
        af = pass ax0;              { buffer to be sent to }
        if ne jump check_init;      { the codec            }

        ay0 = 2;
check_aci1:
        ax0 = dm (rx_buf);          { once initialized, wait for codec }
        ar = ax0 and ay0;           { to come out of autocalibration }
        if eq jump check_aci1;      { wait for bit set }

check_aci2:
        ax0 = dm (rx_buf);          { wait for bit clear }
        ar = ax0 and ay0;
        if ne jump check_aci2;
        idle;

        ay0 = 0xbf3f;               { unmute left DAC }
        ax0 = dm (init_cmds + 6);
        ar = ax0 AND ay0;
        dm (tx_buf) = ar;
        idle;

        ax0 = dm (init_cmds + 7);   { unmute right DAC }
        ar = ax0 AND ay0;
        dm (tx_buf) = ar;
        idle;
        ifc = b#00000011111111;     { clear any pending interrupt }
        nop;

        l0=0; l1=0; l2=0; l3=0; l4=0; l7=0;

        imask = b#0000100101;       { enable rx0 interrupt }

        i7 = ^signon;
        call sendLine;              { send line to host }

        { set up PF0-PF3 }
        ay1 = dm(PFTYPE);
        ax1 = 0xFFF0;
        ar  = ax1 and ay1;
        dm(PFTYPE) = ar;

        { bus settle ? }
        nop;
        nop;

        jump main_loop;

{ command loop - check for incoming data on serial port }

main_loop:  
        ar = dm (CHAR_WAITING_FLAG);            { kbhit () }
        none = pass ar;if ne jump main_loop;

        call process_midi;              { has something }

        jump main_loop;


{ SPORT0 interrupt handler  (called at 48Khz) }
input_samples:

{       These are taken out for speed.
        ax0 = dm(rx_buf + 1);
        ax0 = dm(rx_buf + 2);
}
{
        ax0 = dm(inputmidi);

        dm(tx_buf + 1) = ax0;
        dm(tx_buf + 2) = ax0;
}
        rti;

        
{ transmit interrupt used for Codec initialization }
next_cmd:
        ena sec_reg;
        ax0 = dm (i3, m1);          { fetch next control word and }
        dm (tx_buf) = ax0;          { place in transmit slot 0    }
        ax0 = i3;
        ay0 = ^init_cmds;
        ar = ax0 - ay0;
        if gt rti;                  { rti if more control words still waiting }
        ax0 = 0xaf00;               { else set done flag and }
        dm (tx_buf) = ax0;          { remove MCE if done initialization }
        ax0 = 0;
        dm (stat_flag) = ax0;       { reset status flag }
        rti;

{ MIDI serial port ISR - actually just enables timer, which
  calls timer interrupt to read the serial port }
irq1isr:
        pop sts;
        ena timer;              { start timer now }
        rts;                    { note rts }

nSend:  {rts;}
        i4 = dm (PTR_TO_OUT_CHAR);        { send int }
        call (i4);

nwt:
        ar = dm (CHAR_SEND_DONE_FLAG);
        none = pass ar;
        if eq jump nwt;                 { wait for char to go out }

        rts;

.entry      sendLine;




{******************************************************************************
 *
 *  Send null terminated string pointed to by i7 and LF/CR.  ASCII is in
 *  lower 8-bit.
 *
 *  REGISTER USAGE SUMMARY:
 *
 *  input  : i7
 *  modyfy : none
 *  output : none
 *  destroy: i7, m7 = 1, l7 = 0, ax1
 *  keep   : none
 *  memory : out_char_ax1
 *  calls  : none
 *
 ******************************************************************************}

sendLine:
        l7 = 0;
        m7 = 1;
again:
        ax1 = dm (i7, m7);
        none = pass ax1;
        if eq jump linefeed;
        call nSend;
        jump again;

linefeed:
{        ax1 = 13;
        call nSend;
        ax1 = 10;
        call nSend;
}
        rts;

.endmod;
