.module       DOMAIN;

.include <system.k>;
.include <midi.k>;

.global         handle_MIDI_controller;
.external       process_midi;

.external wave_sin;

{ signal processing variables here }

.var newInput,numXings,oscDelta,oscPhase;
.init numXings:0;
.init oscPhase:0;

.var volume;
.init volume:0x7fff;
.var shiftval;          { octave shifter }
.init shiftval:0;
.var feedback;
.init feedback:0x0000;  { feedback }
.var detune;
.init detune:0x4000;   {init to 0.5, because shifted left }
.var squ;
.init squ:0x1000;
.var dryvol;
.init dryvol:0x4000;
.var bufsize;
.init bufsize:64;

{ internal variables }
.var lastInput;
.init lastInput:0;
.var last_output;
.init last_output:0;
.var dry_input;

.var temp;

.var/dm/ram/circ buffer[256];   { main buffer for holding samples }

.var deltatable[256];

{ parameters here }

{ codec init variables }

.var/dm/ram/circ                rx_buf[3];      { Status + L data + R data }
.var/dm/ram/circ                tx_buf[3];      { Cmd + L data + R data    }
.var/dm/ram/circ                init_cmds[13];
.var/dm                         stat_flag;

.init tx_buf:   0xc000, 0x0000, 0x0000; { Initially set MCE        }

.init init_cmds:0xc007,0xc107,0xc288,0xc388,0xc488,0xc588,0xc680,0xc780,
                0xc85c,0xc909,0xca00,0xcc40,0xcd00;

{ Interrupt vector table }
        jump start;  rti; rti; rti;     {00: reset }
        rti;         rti; rti; rti;     {04: IRQ2 }
        rti;         rti; rti; rti;     {08: IRQL1 }
        rti;         rti; rti; rti;     {0c: IRQL0 }
        ar = dm(stat_flag);             {10: SPORT0 tx }
        ar = pass ar;
        if eq rti;
        jump next_cmd;
        jump input_samples;             {14: SPORT1 rx }
                     rti; rti; rti;
        rti;         rti; rti; rti;     {18: IRQE }
        rti;         rti; rti; rti;     {1c: BDMA }
        jump irq1isr;rti; rti; rti;     {20: SPORT1 tx or IRQ1 }
        rti;         rti; rti; rti;     {24: SPORT1 rx or IRQ0 }
        rti;         rti; rti; rti;     {28: timer }
        rti;         rti; rti; rti;     {2c: power down }


{ ADSP 2181 intialization }

start:
        m7 = 0;
        l7 = 0;
        ax0 = b#0000100000000000;
        dm (System_Control_Reg) = ax0;          { shut down sport 0 }

        i7 = 0x3fe8;            { restore monitor timer handler }
        ar = pm (i7, m7);       { px implicit }
        i7 = 0x28;
        pm (i7, m7) = ar;

        i5 = ^rx_buf;l5 = %rx_buf;
        i6 = ^tx_buf;l6 = %tx_buf;
        i3 = ^init_cmds;l3 = %init_cmds;
        m1 = 1;m5 = 1;

{================== S E R I A L   P O R T   #0   S T U F F ==================}
        ax0 = b#0000110011010111;   dm (SPORT0_Autobuf) = ax0;
        ax0 = 0;    dm (SPORT0_RFSDIV) = ax0;
        ax0 = 0;    dm (SPORT0_SCLKDIV) = ax0;
        ax0 = b#1000011000001111;   dm (SPORT0_Control_Reg) = ax0;
        ax0 = b#0000000000000111;   dm (SPORT0_TX_Channels0) = ax0;
        ax0 = b#0000000000000111;   dm (SPORT0_TX_Channels1) = ax0;
        ax0 = b#0000000000000111;   dm (SPORT0_RX_Channels0) = ax0;
        ax0 = b#0000000000000111;   dm (SPORT0_RX_Channels1) = ax0;

{============== S Y S T E M   A N D   M E M O R Y   S T U F F ==============}
        ax0 = b#0001100000000000;   dm (System_Control_Reg) = ax0;
        ifc = b#00000011111111;         { clear pending interrupt }
        nop;

        icntl = b#00010;
        mstat = b#1000000;

        { ADSP 1847 Codec intialization }
        ax0 = 1;
        dm(stat_flag) = ax0;            { clear flag }
        ena ints;                       { enable transmit interrupt }
        imask = b#0001000000;
        ax0 = dm (i6, m5);              { start interrupt }
        tx0 = ax0;

check_init:
        ax0 = dm (stat_flag);       { wait for entire init }
        af = pass ax0;              { buffer to be sent to }
        if ne jump check_init;      { the codec            }

        ay0 = 2;
check_aci1:
        ax0 = dm (rx_buf);          { once initialized, wait for codec }
        ar = ax0 and ay0;           { to come out of autocalibration }
        if eq jump check_aci1;      { wait for bit set }

check_aci2:
        ax0 = dm (rx_buf);          { wait for bit clear }
        ar = ax0 and ay0;
        if ne jump check_aci2;
        idle;

        ay0 = 0xbf3f;               { unmute left DAC }
        ax0 = dm (init_cmds + 6);
        ar = ax0 AND ay0;
        dm (tx_buf) = ar;
        idle;

        ax0 = dm (init_cmds + 7);   { unmute right DAC }
        ar = ax0 AND ay0;
        dm (tx_buf) = ar;
        idle;
        ifc = b#00000011111111;     { clear any pending interrupt }
        nop;

        l0=0; l1=0; l2=0; l3=0; l4=0; l7=0;
        imask = b#0000100101;       { enable rx0 interrupt }


        call set_baud_31250;    { set serial port to MIDI baud rate }
        call init_params;       { initialize anything you need here }
        jump main_loop;         { begin main codec loop! }

set_baud_31250:
.const CRYSTAL_FREQ_IN_kHZ=   16670;    {   Crystal speed related constant. }
.const  MIDIPERIOD = (CRYSTAL_FREQ_IN_kHZ * 2000 / (3 *  31250)) - 1;
        ax0=MIDIPERIOD;                 { autobaud not used }
        dm(TCOUNT)=ax0;
        dm(TPERIOD)=ax0;            { interrupts generated at 3x baudrate }
        rts;

{ transmit interrupt used for Codec initialization }
next_cmd:
        ena sec_reg;
        ax0 = dm (i3, m1);          { fetch next control word and }
        dm (tx_buf) = ax0;          { place in transmit slot 0    }
        ax0 = i3;
        ay0 = ^init_cmds;
        ar = ax0 - ay0;
        if gt rti;                  { rti if more control words still waiting }
        ax0 = 0xaf00;               { else set done flag and }
        dm (tx_buf) = ax0;          { remove MCE if done initialization }
        ax0 = 0;
        dm (stat_flag) = ax0;       { reset status flag }
        rti;

{ MIDI serial port ISR - actually just enables timer, which
  calls timer interrupt to read the serial port }
irq1isr:
        pop sts;
        ena timer;              { start timer now }
        rts;                    { note rts }

{ do any dynamic memory/variable initializing you need to here }
init_params:
        ax0=dm(bufsize);
        call initBuffer;

        rts;


{ command loop - check for incoming data on serial port }
main_loop:
        ar = dm (CHAR_WAITING_FLAG);    { check serial port for MIDI data }
        none = pass ar;
        if ne jump main_loop;
        call process_midi;        { if MIDI byte received }
        jump main_loop;




{ SPORT0 interrupt handler -- this is called at 44.1KHz }
input_samples:
        ena sec_reg;                { use shadow register bank }

        ax0 = dm(rx_buf +1);    { read a/d converters }
        ay0 = dm(rx_buf +2);    { leave left/right values in my0,my1 }
        mx0 = ax0;

        dm(dry_input)= mx0;     { save for mixing in later }

        my0 = 0x7fff;
        mr  = mx0*my0(ss);

        { mix in feedback }
        mx0 = dm(feedback);
        my0 = dm(last_output);
        mr  = mr + mx0*my0(ss);
        if mv sat mr;
        ar  = mr1;

{        call differentiate;}

        call do_squ;

        dm(newInput)=ar;

        m1 =-1;
        m0 = 0;
        m3 = 3;


        { ------- read out of buffer ------ }

        ax0 = dm(i0,m1);        { look at the end of the buffer }
        ay0 = dm(i0,m0);        { look at the 2nd to last end of the buffer }
        ay1 = -1;                { potential delta to numXings }
        call isZeroXing;

        { ------- write into buffer ------ }

        ax0 = dm(newInput);
        dm(i0,m1)= ax0;         { write new value in place }
        ay0 = dm(i0,m3);        { get nearby sample info for trans detect }
        ay1 =  1;               { potential delta to numXings }
        call isZeroXing;

        { lookup delta, given number of zero-crossings in buffer  }
        mx0=dm(numXings);
        my0=0x400;
        mr = mx0*my0(ss);   
        dm(oscDelta)=mr0;
        ax0 = mr0;

        { special octavizer }
        ar  = dm(shiftval);
        se  = ar;
        ar  = dm(oscDelta);
        sr  = ashift ar (lo);
        ax0 = sr0;

        { implement fine tuning a.k.a.detune }
        mx0 = ax0;
        my0 = dm(detune);
        mr  = mx0*my0(ss);
        ax0 = mr1;

        { increment accumulator delta }
        ay0 = dm(oscPhase);
        ar  = ax0+ay0;
        dm(oscPhase)=ar;

        { use phase to generate sample [sinusoid wavetable] }
        sr0=dm(oscPhase);
        sr  = lshift sr0 by -8 (lo);        { use upper 8 bits }
        ax0 = sr0;                          { waveform phase in ay1 }

        ay0=^wave_sin;
        ar = ax0+ay0;
        i1=ar;
        l1=0;
        ax0=dm(i1,m0);

        { save output value (for feedback) }
        dm(last_output)=ax0;
        
        { do wet volume }
        mx0 = ax0;
        my0 = dm(volume);
        mr  = mx0*my0(ss);

        { mix in dry }
        mx0 = dm(dry_input);
        my0 = dm(dryvol);
        mr  = mr + mx0*my0(ss);

        { write d/a converters }
        ax0 = mr1;
        dm(tx_buf+ 1)=ax0;      
        dm(tx_buf+ 2)=ax0;      { write left/right values from my0, my1 }

        
thatwasfun:
        rti;    

{ don't let any sound through unless it's loud enough }
do_squ:
        dm(temp)=ar;
        ar  = ar and 0x7fff;  { get magnitude }
        ay0 = dm(squ);
        ar  = ar - ay0;
        if lt jump tooQuiet;
        ar  = dm(temp);       { restore orig sample }
        rts;
tooQuiet:
        ar  =0;                 { get squed }
        rts;


{ supply the differential instead, to get more zero-crossings }
differentiate:
        mx0 = 0x3fff;           { divide input by two }
        my0 = ar;
        mr  = mx0*my0(ss);
        ax0 = mr1;

        ay0 = dm(lastInput);    { save for next time }
        dm(lastInput) = ax0;

        ar  = ax0 - ay0;        { get differential from inp and last }

        rts;

{ determine if a sign transition has occurred }
{ ax0 is the newer sample }
{ ay0 is the older sample }

isZeroXing:

        ar  = ax0 xor ay0;              { compare their signs }
        ar  = tstbit 15 of ar;         
        if eq jump blah1;               { they're equal, no zero-crossing }

        ax0 = dm(numXings);
        ar  = ax0 + ay1;
        dm(numXings) = ar;

blah1:
        rts;


{ Here is where MIDI messages are used to set variables in your Effect! }
handle_MIDI_controller:
        ax1 = dm(midi_cont);
        ar  = dm(midi_val);
        ay1 = 1;none = ax1-ay1; if eq jump set_dryvol;
        ay1 = 2;none = ax1-ay1; if eq jump set_vol;

        ay1 = 3;none = ax1-ay1; if eq jump set_squ;
        ay1 = 4;none = ax1-ay1; if eq jump set_octshift;
        ay1 = 5;none = ax1-ay1; if eq jump set_detune;
        ay1 = 6;none = ax1-ay1; if eq jump set_feedback;

        ay1 = 7;none = ax1-ay1; if eq jump set_bite;
        ay1 = 8;none = ax1-ay1; if eq jump set_porta;
        ay1 = 9;none = ax1-ay1; if eq jump set_inpfilt;

        ay1 = 10;none = ax1-ay1; if eq jump set_envdepth;
        ay1 = 11;none = ax1-ay1; if eq jump set_envfollow;  { time, filter }

        ay1 = 12;none = ax1-ay1; if eq jump set_shperiod;
        ay1 = 13;none = ax1-ay1; if eq jump set_bufsize;

        ay1 = 69;none = ax1-ay1;if eq jump set_blah69;
        ay1 = 127;none = ax1-ay1;if eq jump set_blah127;
        rts;

set_vol:
        ay1 = dm(midi_val);
        ar  = dm(midi_val);
        sr  = lshift ar by 8(lo);
        ar  = sr0 or ay1;
        dm(volume)=ar;
        rts;

set_dryvol:
        ay1 = dm(midi_val);
        ar  = dm(midi_val);
        sr  = lshift ar by 8(lo);
        ar  = sr0 or ay1;
        dm(dryvol)=ar;
        rts;

set_octshift:
        mr0 = ar;
        sr  = lshift mr0 by -2 (lo);  { 7-bit -> 5-bit = 0-31 }
        ar  = sr0 - 16;                {-15<->16 } { don't forget extra shift needed for detune! }
        ar  = ar + 1;
        dm(shiftval)=ar;
        rts;

set_detune:
        mr2 = 0;
        mr0 = 0;
        mr1 = 0x4000;

        mx0 = ar;
        my0 = 0x800;   { should be 0x200 }
        mr  = mr + mx0*my0(ss);
        
        {
                remember MSTAT mode!
                0x7f * 0x200   = 0x3fff;
                0x40 * 0x200   = 0x2000;
                0x00 * 0x200   = 0x0000;
        }

        dm(detune) = mr1;
        rts;


set_feedback:
        ay1 = dm(midi_val);
        ar  = dm(midi_val);
        sr  = lshift ar by 6(lo);
        ar  = sr0 or ay1;
        dm(feedback)=ar;
        rts;


set_porta:
        rts;


set_bite:
        rts;

set_inpfilt:
        rts;

set_squ:
        ay1 = dm(midi_val);
        ar  = dm(midi_val);
        sr  = lshift ar by 8(lo);
        ar  = sr0 or ay1;
        dm(squ)=ar;
        rts;

set_shperiod:
        rts;

set_bufsize:

        ay1 = dm(midi_val);
        mr0 = ay1;
        sr  = lshift mr0 by -4 (lo);  { 7-bit -> 3-bit = 0-7 }
        se  = sr0;
        ar  = 1;
        sr  = ashift ar (lo);

        dm(bufsize)=ar;
        
        call initBuffer;
        rts;

set_blah69:
        ay1 = dm(midi_val);
        rts;

set_blah127:
        ay1 = dm(midi_val);
        rts;

set_envdepth:
        rts;

set_envfollow:
        rts;

        

initBuffer:
        ax0=dm(bufsize);

        { clear buffer memory to avoid junk }
        i0=^buffer;
        l0=ax0;
        m0=1;
        ax0=0;
        
        cntr = 256;
        do clearWord until ce;
clearWord:dm(i0,m0)=ax0;

        nop;
        nop;
        nop;

        ax0 = 0;
        dm(numXings) = ax0;
        rts;


.endmod;
