.module/RAM/ABS=0       SYNTH;

.var/dm/ram/circ filtbuf[4];
.var/pm/ram/circ coeffs[5];
{.init coeffs[000]:h#0014,h#0029,h#0014,h#8113,h#3f3e;}  { f500.0Hz Q6.0 LPF }
 .init coeffs[000]:h#0014,h#0029,h#0014,h#3f3e,h#8113;  { f500.0Hz Q6.0 LPF }

{
  does much in its interrupt handler...
  Codec interrupt has higher priority?
  should MIDI Serial Interrupt disable interrupts?
}

.include <system.k>;
.include <synth.k>;
.include <adsr.k>;

.global nSend;

.global ampenv;
.external countdown;  { for adsr compute timeout }

.global set_fricaseeb;
.external waveseq_incclk;

.var return_to_mon;
.init return_to_mon:0x0000;
.var calc_another;
.init calc_another:0x1;

{ synth functions }
.global newsound;
.global synth_cont;

.external process_midi;
.external inputmidi;

.external unkillsound;

.external wave_sin;
.external wave_squ;
.external wave_tri;
.external wave_saw;

.external wave_noi;
.external wave_ovr;
.external wave_bur;
.external wave_trp;

{ Variables }

.var/dm/ram signon [11];
.init signon:
'S','y','n','t','h','0','4',0;

{ These are for the waveform playback }
.var freqtab[128];               { frequency table }
.include <freqtab.h>;

.var
    input1, input2, output1, output2;

{ synth parameters }
.var
    wavea, waveb, ab_phase,                          {1-3}
    bxpose[4],                                       {5-8}
    bxpose_freq, ab_combine_op, quantize, dist_lvl, {9-12}
    fltr_lvl, volume, pan,                         {13-16}
    inp1_lvl,inp2_lvl,                             {17-18}
    fmmode,syncmode,rotang,                        {19-21}
    lpf1,lpf2,                                     {22-23}
    fricaseeb,oscbdetune,                          {24-25}
    attack, decay, sustain, release,
    yuk;

{ initing synth parameters }
.init wavea:0x0;
.init waveb:0x0;
.init ab_phase:0;

.init bxpose:0x0,0x0,0x0,0x0;
.init bxpose_freq:0x0;

.init ab_combine_op:0x0;

.init quantize:0x0;
.init dist_lvl:0x0;
.init fltr_lvl:0x0080;

.init decay:0x0020;
.init volume:0x60;   { out of 0x007f, starts out at 3/4 volume }
.init pan:0x0040;    { right in the middle }

.init inp1_lvl:0x7f;
.init inp2_lvl:0x7f;

.init fmmode:0x0;
.init rotang:0x0;

.init yuk:0x0;

{ values stored for speed }
.var velo_mult;
.var waveforms[9];  { last pointer equal to first }  { for osc #1 }
.var waveforms2[9]; { last pointer equal to first }  { for osc #2 }
.var waveforma,waveformb;
.var waveforma2,wavemula,wavemula2;
.var waveformb2,wavemulb,wavemulb2;
.var wavea_phase,wavea_delta;
.var waveb_phase,waveb_delta;
.var detuneval;
.var ab_phase_add;
.var fricbmul;
.var wavea_res,waveb_res;
.var cur_midi_note;

.var lpf1yn,lpf1xn;
.var lpf2yn,lpf2xn;
.var last_wavea,last_waveb;

.var sync_phase1;
.var sync_phase2;

.var quant_mask;

.var volume_mul;
.var left_pan;
.var right_pan;

.var inp1_mul,inp2_mul;

.var syncmode1;    
.var syncmode2;

.var rotindexcos;
.var rotindexsin;

.var yuk_mask;

{ init values stored for speed }
.init waveforms :^wave_sin,^wave_squ,^wave_tri,^wave_saw,^wave_noi,^wave_ovr,^wave_bur,^wave_trp,^wave_sin;
.init waveforms2:^wave_tri,^wave_sin,^wave_squ,^wave_saw,^wave_ovr,^wave_noi,^wave_bur,^wave_trp,^wave_tri;
.init waveforma :^wave_sin;
.init waveforma2:^wave_squ;
.init waveformb :^wave_tri;
.init waveformb2:^wave_sin;

.init wavemula :0x7fff;
.init wavemula2:0x0000;
.init wavemulb :0x7fff;
.init wavemulb2:0x0000;

.init wavea_phase:0x0000;
.init wavea_delta:0x0000;
.init waveb_phase:0x0000;
.init waveb_delta:0x0000;
.init detuneval:  0x0000;

.init ab_phase_add:0x0000;
.init fricbmul:0x0000;

.init lpf1yn:0x0000;    { init low-pass filters }
.init lpf1xn:0x7fff;
.init lpf2yn:0x0000;
.init lpf2xn:0x7fff;
.init last_wavea:0x0000;
.init last_waveb:0x0000;

.init quant_mask:0xffff;
 
.init volume_mul:0x7fff;
.init left_pan:0x3fff;
.init right_pan:0x3fff;

.init inp1_mul:0x7fff;
.init inp2_mul:0x7fff;

.init syncmode1:0x0;    
.init syncmode2:0x0;

.init rotindexcos:0x0000;  { 90 degress }
.init rotindexsin:0x4000;  { 90 degrees }

.init yuk_mask:0xffff;

{ scratchpad variables }
.var preenv;

.var  ab_phase_LFO_enable;
.init ab_phase_LFO_enable:0x0000;
.var  ab_phase_LFO_countdown;
.init ab_phase_LFO_countdown:0x001b;  { 27 is magic coefficient }
.var  ab_phase_LFO_rate;
.init ab_phase_LFO_rate:0x0000;
.var  ab_phase_LFO_step;
.init ab_phase_LFO_step:0x0001;

.var  waveseq_cntdwn;
.init waveseq_cntdwn:7500;

{ envelope generator }
{                       A      D      S      R    }
.var ampenv[6];
.init ampenv:0x0,0x0,0x1000,0x1000,0x1000,0x07d0; 

{ uninitialized data }
.var synthout,synthout1,synthout2;
.var crumbout;

{ Setting data }

.var/dm/ram/circ                rx_buf[3];      { Status + L data + R data }
.var/dm/ram/circ                tx_buf[3];      { Cmd + L data + R data    }
.var/dm/ram/circ                init_cmds[13];
.var/dm                         stat_flag;

.init tx_buf:   0xc000, 0x0000, 0x0000; { Initially set MCE        }
.init init_cmds:0xc002,0xc102,0xc288,0xc388,0xc488,0xc588,0xc680,0xc780,
                0xc85b,0xc909,0xca00,0xcc40,0xcd00;
                { c85b for 44 KHz sample rate }

{ Interrupt vector table }
        jump start;  rti; rti; rti;     {00: reset }
        rti;         rti; rti; rti;     {04: IRQ2 }
        rti;         rti; rti; rti;     {08: IRQL1 }
        rti;         rti; rti; rti;     {0c: IRQL0 }
        ar = dm(stat_flag);             {10: SPORT0 tx (Codec) }
        ar = pass ar;
        if eq rti;
        jump next_cmd;
        jump input_samples;             {14: SPORT1 rx (Codec) }
                     rti; rti; rti;
        rti;         rti; rti; rti;     {18: IRQE }
        rti;         rti; rti; rti;     {1c: BDMA }
        jump irq1isr;rti; rti; rti;     {20: SPORT1 tx or IRQ1 }
        rti;         rti; rti; rti;     {24: SPORT1 rx or IRQ0 }
        rti;         rti; rti; rti;     {28: timer }
        rti;         rti; rti; rti;     {2c: power down }


{ ADSP 2181 intialization }

start:
        m7 = 0;
        l7 = 0;
        ax0 = b#0000100000000000;
        dm (System_Control_Reg) = ax0;          { shut down sport 0 }

        i7 = 0x3fe8;            { restore monitor timer handler }
        ar = pm (i7, m7);       { px implicit }
        i7 = 0x28;
        pm (i7, m7) = ar;

        i5 = ^rx_buf;l5 = %rx_buf;
        i6 = ^tx_buf;l6 = %tx_buf;
        i3 = ^init_cmds;l3 = %init_cmds;
        m1 = 1;m5 = 1;

{================== S E R I A L   P O R T   #0   S T U F F ==================}
        ax0 = b#0000110011010111;   dm (SPORT0_Autobuf) = ax0;
        ax0 = 0;    dm (SPORT0_RFSDIV) = ax0;
        ax0 = 0;    dm (SPORT0_SCLKDIV) = ax0;
        ax0 = b#1000011000001111;   dm (SPORT0_Control_Reg) = ax0;
        ax0 = b#0000000000000111;   dm (SPORT0_TX_Channels0) = ax0;
        ax0 = b#0000000000000111;   dm (SPORT0_TX_Channels1) = ax0;
        ax0 = b#0000000000000111;   dm (SPORT0_RX_Channels0) = ax0;
        ax0 = b#0000000000000111;   dm (SPORT0_RX_Channels1) = ax0;

{============== S Y S T E M   A N D   M E M O R Y   S T U F F ==============}
        ax0 = b#0001100000000000;   dm (System_Control_Reg) = ax0;
        ifc = b#00000011111111;         { clear pending interrupt }
        nop;

        icntl = b#00010;
        mstat = b#1000000;

        { ADSP 1847 Codec intialization }
        ax0 = 1;
        dm(stat_flag) = ax0;            { clear flag }
        ena ints;                       { enable transmit interrupt }
        imask = b#0001000000;
        ax0 = dm (i6, m5);              { start interrupt }
        tx0 = ax0;

check_init:
        ax0 = dm (stat_flag);       { wait for entire init }
        af = pass ax0;              { buffer to be sent to }
        if ne jump check_init;      { the codec            }

        ay0 = 2;
check_aci1:
        ax0 = dm (rx_buf);          { once initialized, wait for codec }
        ar = ax0 and ay0;           { to come out of autocalibration }
        if eq jump check_aci1;      { wait for bit set }

check_aci2:
        ax0 = dm (rx_buf);          { wait for bit clear }
        ar = ax0 and ay0;
        if ne jump check_aci2;
        idle;

        ay0 = 0xbf3f;               { unmute left DAC }
        ax0 = dm (init_cmds + 6);
        ar = ax0 AND ay0;
        dm (tx_buf) = ar;
        idle;

        ax0 = dm (init_cmds + 7);   { unmute right DAC }
        ar = ax0 AND ay0;
        dm (tx_buf) = ar;
        idle;
        ifc = b#00000011111111;     { clear any pending interrupt }
        nop;

        l0=0; l1=0; l2=0; l3=0; l4=0; l7=0;

        imask = b#0000100101;       { enable rx0 interrupt }

        i7 = ^signon;
        call sendLine;              { send line to host }

{        jump set_baud_9600;    }

        { set baud rate of serial port to 31250 bps }
set_baud_31250:
.const CRYSTAL_FREQ_IN_kHZ=   16670;    {   Crystal speed related constant. }
.const  MIDIPERIOD = (CRYSTAL_FREQ_IN_kHZ * 2000 / (3 *  31250)) - 1;
        ax0=MIDIPERIOD;                 { autobaud not used }
        dm(TCOUNT)=ax0;
        dm(TPERIOD)=ax0;            { interrupts generated at 3x baudrate }

set_baud_9600:

        jump main_loop;

{ realtime command loop - check for incoming data on serial port }
main_loop:  
        ar   = dm (CHAR_WAITING_FLAG);  { check for incoming MIDI data }
        none = pass ar;
        if eq call process_midi;        { process MIDI byte }
        
        ar   = dm(calc_another);        { check to calc synth sample }
        none = pass ar;
        if ne call calc_synth;

        ax1 = dm(return_to_mon);        { check return to mon }
        ar = tstbit 0 of ax1;
        if ne rts;

        {call check_waveseq; }            { check update wave seq }

        jump main_loop;

check_waveseq:
        ar  = dm(waveseq_cntdwn);
        ar  = ar - 1;
        dm(waveseq_cntdwn) = ar;
        if ne rts;
        ar  = 7500;
        dm(waveseq_cntdwn) = ar;
        call waveseq_incclk;
        rts;

{ SPORT0 interrupt handler  (called at 44.1 KHz) }
input_samples:
        ena sec_reg;

        { get and save input }
        ax0 = dm(rx_buf + 1);
        ax1 = dm(rx_buf + 2);
        dm(input1) = ax0;
        dm(input2) = ax1;

        { write last calc'd synth samples to DAC buffer }
        ax0 = dm(synthout1);            
        ax1 = dm(synthout2);            
        dm(tx_buf + 1) = ax0;
        dm(tx_buf + 2) = ax1;

        { tell main loop it should calc another sample }
        ax0 = 1;
        dm(calc_another)=ax0;

        rti;


{ synthesizer algorithm entry point }
calc_synth:
        call actual_calc;
{        call actual_calc;}
{        call actual_calc;}
{        call actual_calc;}
        rts;

actual_calc:
        set fl2;
        call calc_wavea;   { returns waveform value in ax1 }
        dm(wavea_res) = ax1;

check_phase_LFO_enable:
        ar = dm(ab_phase_LFO_enable);
        none = pass ar;
        if eq jump skip_phase_LFO_calc;

        { we know it's getting enabled }                

check_phase_LFO_countdown:
        ax0 = dm(ab_phase_LFO_countdown);
        ar  = ax0 - 1;
        none = pass ar;
        dm(ab_phase_LFO_countdown)=ar;
        if ne jump skip_phase_LFO_calc;

reload_phase_countdown:
        ax0 = 0x001b;   { 27 is the magic number }
        dm(ab_phase_LFO_countdown)=ax0;

        { we know this countdown is occurring }

check_phase_LFO_divider:
        ax0 = dm(ab_phase_LFO_step);
        ar  = ax0 - 1;
        none = pass ar;
        dm(ab_phase_LFO_step)=ar;
        if ne jump skip_phase_LFO_calc;

reload_phase_LFO_divider:
        ax0 = dm(ab_phase_LFO_rate);
        dm(ab_phase_LFO_step)=ax0;

do_calc_phase_LFO_calc:
        ax0 = dm(ab_phase_add);
        ar  = ax0 + 1;

done_calc_phase_LFO:
        dm(ab_phase_add) = ar;

skip_phase_LFO_calc:
        call calc_waveb;   { returns waveform value in ax0 }
        dm(waveb_res) = ax0;

        call combine_ab;   { returns waveform in mr1 }

        call do_quantize;  { returns wavform in mr1 }

        { do volume }
        my0 = dm(volume_mul);
        mr  = mr1*my0(ss);

        dm(preenv) = mr1;

        { do decay envelope }
        i0  = ^ampenv;
        call do_adsr;           { returns value in ar }
        mx0 = ar;
        my0 = dm(preenv);
        mr  = mx0*my0(ss);      
        my1 = dm(velo_mult);    { use note velocity to modulate volume }
        mr  = mr1*my1(ss);
        dm(synthout)=mr1;       { save it here }

        {call renderkick1;   }    { do drums, return value in mr1 }
        mr1 = 0;
        dm(crumbout)=mr1;

        {call do_filter;} {mr1 in, mr1 out }
 
        { mixer section }
        my0 = dm(synthout);     { synthesizer output }
        mx0 = dm(left_pan);
        mr  = mx0*my0(ss);

        mx0 = dm(input1);               { add input 1 }
        my0 = dm(inp1_mul);
        mr  = mr + mx0*my0(ss);         

        mx0 = dm(input2);               { add input 2 }
        my0 = dm(inp2_mul);
        mr  = mr + mx0*my0(ss);

        mx0 = 0x7fff;                   { crumbs }
        my0 = dm(crumbout);
        mr  = mr + mx0*my0(ss);

        if mv sat mr;
        dm(synthout1) = mr1;            { final left output value }

        my0 = dm(synthout);     { synthesizer output }
        mx0 = dm(right_pan);
        mr  = mx0*my0(ss);

        mx0 = dm(input1);               { add input 1 }
        my0 = dm(inp1_mul);
        mr  = mr + mx0*my0(ss);         

        mx0 = dm(input2);               { add input 2 }
        my0 = dm(inp2_mul);
        mr  = mr + mx0*my0(ss);         

        mx0 = 0x7fff;                   { crumbs }
        my0 = dm(crumbout);
        mr  = mr + mx0*my0(ss);

        if mv sat mr;
        dm(synthout2) = mr1;            { final left output value }

        call samplewaveforms;

done_synth:
        { tell main loop we finished calc'ing another sample }
        ax0 = 0;
        dm(calc_another)=ax0;
        
        reset fl2;
        rts;

{ returns waveform value in ax1 }
calc_wavea:   { calculate synthesizer voice }
        sr0 = dm(wavea_phase);              { get synthesizer phase }
        sr  = lshift sr0 by -8 (lo);
        ay1 = sr0;                          { use upper 8 bits as index }

        ar  = dm(waveforma);
        ar  = ar + ay1;                     { base of waveform }
        i0  = ar;
        mx0 = dm(i0,m0);                    { read 1st waveform }

        ar  = dm(waveforma2);
        ar  = ar + ay1;                     { base of  waveform }
        i0  = ar;
        mx1 = dm(i0,m0);                    { read 2nd waveform }

        my0 = dm(wavemula);
        my1 = dm(wavemula2);
        mr  =      mx0*my1(ss);             { mix waveforms }
        mr  = mr + mx1*my0(ss);
        ax1 = mr1;                          { final value }

        mx0 = dm(lpf1xn);          { calc LPF }
        my0 = mr1;
        mx1 = dm(lpf1yn);
        my1 = dm(last_wavea);
        mr  =      mx0*my0(ss);         { y[n] = (1-a)*x[n] - a*y[n-1] }
        mr  = mr + mx1*my1(ss);
        ax1 = mr1;

        dm(last_wavea)=ax1;     { save for y[n-1] }

adv_wavea:
        ar  = dm(wavea_phase);            { get synthesizer phase }
        ay1 = dm(wavea_delta);            { add delta }
        ar  = ar + ay1;
        dm(wavea_phase) = ar;               { increase phase of synth voice }

        if av jump resync_waveb;

        rts;

resync_waveb:
        ax1  = dm(syncmode1);
        none = pass ax1;
        if eq rts;

        ax1  = dm(sync_phase1);
        dm(waveb_phase)=ax1;
        rts;

{ returns waveform value in ax0 }
calc_waveb:   { calculate synthesizer voice }
        sr0 = dm(waveb_phase);              { get synthesizer phase }
        sr  = lshift sr0 by -8 (lo);        { use upper 8 bits }
        ay1 = sr0;                          { waveform phase in ay1 }

        ar  = dm(ab_phase_add);         
        ar  = ar + ay1;                     { add phase offset }
       
        mx0 = dm(last_wavea);		    { do fricasee'ing }
        my0 = dm(fricbmul);                 { use sample output from A }
        mr  = mx0*my0(ss);		    { to offset phase for wave B }
        ay1 = mr1;
        ar  = ar + ay1;

        ay0 = 0x00ff;                   { keep within range }
        ar  = ar AND ay0;               { phase in ar }
        ay1 = ar;                       { phase in ay1 }

        ar  = dm(waveformb);            { ptr to wavetable }
        ar  = ar + ay1;                     { as index to waveform }
        i0  = ar;
        mx0 = dm(i0,m0);                    { read waveform }

        ar  = dm(waveformb2);
        ar  = ar + ay1;                     { as index to waveform }
        i0  = ar;
        mx1 = dm(i0,m0);                    { read waveform }

        my0 = dm(wavemulb);
        my1 = dm(wavemulb2);
        mr  =      mx0*my1(ss);             { mix em proportionally }
        mr  = mr + mx1*my0(ss);
        ax0 = mr1;                          { final value }

        mx0 = dm(lpf2xn);          { calc LPF }
        my0 = mr1;
        mx1 = dm(lpf2yn);
        my1 = dm(last_waveb);
        mr  =      mx0*my0(ss);         { y[n] = (1-a)*x[n] - a*y[n-1] }
        mr  = mr + mx1*my1(ss);
        ax0 = mr1;
        dm(last_waveb)=ax0;     { save for y[n-1] }

adv_waveb:
        ar  = dm(waveb_phase);            { get synthesizer phase }
        ay1 = dm(waveb_delta);            { add delta }
        ar  = ar + ay1;
        dm(waveb_phase) = ar;             { increase phase of synth voice }

        rts;   { debug code }
        if av jump resync_wavea;

        rts;

resync_wavea:
        ax1  = dm(syncmode2);
        none = pass ax1;
        if eq rts;

        ax1  = dm(sync_phase2);
        dm(wavea_phase)=ax1;

        rts;


combine_ab:
        ax1 = dm(ab_combine_op);

        ay1 =  0;none = ax1-ay1;if eq jump combine_add1;
        ay1 =  1;none = ax1-ay1;if eq jump combine_add2;
        ay1 =  2;none = ax1-ay1;if eq jump combine_add3;
        ay1 =  3;none = ax1-ay1;if eq jump combine_mul;

        ay1 =  4;none = ax1-ay1;if eq jump combine_and;
        ay1 =  5;none = ax1-ay1;if eq jump combine_or;
        ay1 =  6;none = ax1-ay1;if eq jump combine_xor;

        ay1 =  7;none = ax1-ay1;if eq jump combine_max1;
        ay1 =  8;none = ax1-ay1;if eq jump combine_max2;

        ay1 =  9;none = ax1-ay1;if eq jump combine_justa;
        ay1 = 10;none = ax1-ay1;if eq jump combine_justb;

        ay1 = 11;none = ax1-ay1;if eq jump combine_shift;
        ay1 = 12;none = ax1-ay1;if eq jump combine_addmul;
        ay1 = 13;none = ax1-ay1;if eq jump combine_ringmod;
        
combine_add1:  { combine op #0 }
        mx0 = dm(wavea_res); { wave A }
        mx1 = dm(waveb_res); { wave B }
        my0 = 0x3fff;        { equal mixing }

        mr  = mx0*my0(ss);      
        mr  = mr + mx1*my0(ss);
        rts;

combine_add2:  { combine op #1 }
        mx0 = dm(wavea_res); { wave A }
        mx1 = dm(waveb_res); { wave B }
        my0 = 0x7fff;        { overdrive mixing }

        mr  = mx0*my0(ss);      
        mr  = mr + mx1*my0(ss);
        if mv sat mr;
        rts;

combine_add3:  { combine op #2 }
        mx0 = dm(wavea_res); { wave A }
        mx1 = dm(waveb_res); { wave B }
        my0 = 0x7fff;      { overdrive w/ loop distortion mixing }

        mr  = mx0*my0(ss);      
        mr  = mr + mx1*my0(ss);
	{ eliminate the saturation for loop distortion effect }
        rts;

combine_mul:   { combine op #3 }
        mx0 = dm(wavea_res); { wave A }
        my0 = dm(waveb_res); { wave B }
        mr  = mx0*my0(ss);
        rts;               
        
combine_and:   { combine op #4 }
        ax0 = dm(wavea_res);
        ay0 = dm(waveb_res);
        ar  = ax0 and ay0;
        mr1 = ar;
        rts;

combine_or:    { combine op #5 }
        ax0 = dm(wavea_res);
        ay0 = dm(waveb_res);
        ar  = ax0 or  ay0;
        mr1 = ar;
        rts;

combine_xor:   { combine op #6 }
        ax0 = dm(wavea_res);
        ay0 = dm(waveb_res);
        ar  = ax0 xor ay0;
        mr1 = ar;
        rts;

combine_max1:  { combine op #7 }
        ax0 = dm(wavea_res);
        ay0 = dm(waveb_res);
        ar  = ax0 - ay0;
        mr1 = ax0;
        if gt rts;
        mr1 = ay0;
        rts;		{ returns the greater one }

combine_max2:  { combine op #8 }
        ax0 = dm(wavea_res);
        ay0 = dm(waveb_res);
        ar  = ax0 - ay0;
        mr1 = 0;
        if gt rts;

        mx0 = dm(wavea_res); { wave A }
        mx1 = dm(waveb_res); { wave B }
        my0 = 0x6fff;        { slight overdrive mixing }

        mr  = mx0*my0(ss);      
        mr  = mr + mx1*my0(ss);
        if mv sat mr;

        rts;		{ returns 0 or the sum of the two }

combine_justa:	{ combine op #9 }
	ax0 = dm(wavea_res);
	mr1 = ax0;
	rts;  		{ just returns waveform a }

combine_justb: 	{ combine op #10 }
	ax0 = dm(waveb_res);
	mr1 = ax0;
	rts;  		{ just returns waveform b }

combine_shift:  { combine op #11 }
	ax0 = dm(wavea_res);	
        mr1 = ax0;

	rts;	{ shifts waveform a by the amount in waveform b}

combine_addmul: { combine op #12 }
        mx0 = dm(wavea_res); { wave A }
	my0 = dm(waveb_res); { wave B }
        mx1 = 0x47ff;        { ~1/2 }
	mf  = mx0*my0(ss);
        mr  = mx1 * mf(ss);
	
        mx0 = dm(wavea_res); { wave A }
        my0 = 0x4fff;        { slightly imbalanced equal mixing }
	mr  = mr + mx0*my0(ss);
        mx1 = dm(waveb_res); { wave B }
        my1 = 0x37ff;        { slightly imbalanced equal mixing }
	mr  = mr + mx1*my1(ss);
        if mv sat mr;

	rts;  { returns approx. a/2+b/2+a*b/2 }	

combine_ringmod: { combine op #13 C64 style magnitude flipping }
        ax0 = dm(wavea_res); { wave A }
        ay0 = 0x8000;           { extract sign bit }
        ar  = ax0 and ay0;

        ay0 = dm(waveb_res); { wave B }
        ar  = ax0 xor ay0;   { use wave B, with wave A sign inverting it }
        mr1 = ar;        

        rts;

{ input is mr1, output is mr1 }
do_quantize:
        ax0 = mr1;
        ay0 = dm(quant_mask);
        ar  = ax0 and ay0;
        mr1 = ar;
        rts;

{expects:
 sr1-> input x[n]
 i0 -> delay line buffer for x(n-2), x(n-1), y(n-2), y(n-1)
 l0 -> 0
 i1 -> scaling factors for each biquad section
 l1 -> 0 (in the case of a single biquad )
 i4 -> scaled biquad coefficients
 l4 = 5x[number of biquads]

 m0, m4 = 1
 m1 = -3
 m2 = 0 (in the case of a single biquad)
 m3 = (1 - length of delay line buffer)
}
do_filter:
        sr1 = mr1;
        i0  = ^filtbuf;
        l0  = 0;
        l1  = 0;
        i4  = ^coeffs;
        l4  = 5;

        m0  = 1;
        m4  = 1;
        m1  = -3;
        m2  = 0;
        m3  = -3;


{        call do_iir;}

        mr1 = sr1;

        rts;

samplewaveforms:
check_wave1:
        ay1  = dm(PFDATA);
        ax1  = 0x0001;
        ar   = ax1 and ay1;
        none = pass ar;
        if eq jump check_wave2;

sample_wave1:

check_wave2:
        ay1  = dm(PFDATA);
        ax1  = 0x0001;
        ar   = ax1 and ay1;
        none = pass ar;
        if ne jump done_sample;

sample_wave2:

done_sample:
        rts;


{ Use MIDI note number to set sample pitch ---------------------------- }
{ set ay1 to midi_note b4 calling this }
{ sr0 contains scaled velocity multiplier }
newsound:
        dm(velo_mult) = sr0;
{ set VCO's }
set_vcoa:
        dm(cur_midi_note)=ay1;
        ar  = ^freqtab;
        ar  = ar + ay1;
        ay0 = 0x0018;    { lower it two octaves }
        ar  = ar - ay0;
        ay0 = dm(bxpose);  { add oscillator transpose value }
        ar  = ar + ay0;
        i0  = ar;
        ay1 = dm(i0,m0);                { get delta for that note }
        ar  = dm(yuk_mask);              { yuk it up }
        ar  = ar and ay1;
        dm(wavea_delta) = ar;            { use it }

set_vcob:
        ar  = ^freqtab;
        ar  = ar + ay1;
        ay0 = 0x0018;    { lower it two octaves }
        ar  = ar - ay0;
        i0  = ar;
        ax1 = dm(i0,m0);                { get delta for that note }
        dm(waveb_delta) = ax1;

        {call unkillsound;}     { originally in for debug purposes }
        {jump skipblahpart;}    { originally in for debug purposes }

{ trigger VCA }
        l0  = 0;
        m0  = 1;
        i0  = ^ampenv;                  
        ax1 = 1;
        dm(i0,m0) = ax1;        { set ADSR state to Attack }

        ax1 = 0x0000;           { init ADSR level to 0x0000 }
        dm(i0,m0) = ax1;

        ax1 = 0x0001;
        dm(countdown) = ax1;    { force adsr computation on next cycle }

        rts;


{ ax0 = midi_val, ax1 = midi_cont }
synth_cont:

{waves} ay1 =   1;none = ax1-ay1;if eq jump set_wavea;
        ay1 =   2;none = ax1-ay1;if eq jump set_waveb;
        ay1 =   3;none = ax1-ay1;if eq jump set_ab_phase;

        ay1 =  22;none = ax1-ay1;if eq jump set_lpf1;
        ay1 =  23;none = ax1-ay1;if eq jump set_lpf2;

{bxpose}ay1 =   5;none = ax1-ay1;if eq jump set_bxpose1;
        ay1 =   6;none = ax1-ay1;if eq jump set_bxpose2;
        ay1 =   8;none = ax1-ay1;if eq jump set_bxpose4;
        ay1 =   9;none = ax1-ay1;if eq jump set_bxpose_freq;

{synth} ay1 =  20;none = ax1-ay1;if eq jump set_ab_combine_op; { was 10 }

{muck}  ay1 =  11;none = ax1-ay1;if eq jump set_quantize;
        ay1 =  12;none = ax1-ay1;if eq jump set_dist_lvl;
        ay1 =  13;none = ax1-ay1;if eq jump set_fltr_lvl;

{mix}   ay1 =  73;none = ax1-ay1;if eq jump set_attack;  { MIDI Standard }
{mix}   ay1 =  76;none = ax1-ay1;if eq jump set_decay;   { MIDI Standard }
{mix}   ay1 =  75;none = ax1-ay1;if eq jump set_sustain; { MIDI Standard }
{mix}   ay1 =  72;none = ax1-ay1;if eq jump set_release; { MIDI Standard }
        ay1 =   7;none = ax1-ay1;if eq jump set_volume;  { MIDI Standard }
        ay1 =  10;none = ax1-ay1;if eq jump set_pan;     { MIDI Standard }

{X mix} ay1 =  17;none = ax1-ay1;if eq jump set_inp1_lvl;
        ay1 =  18;none = ax1-ay1;if eq jump set_inp2_lvl;

{FX}    ay1 =  19;none = ax1-ay1;if eq jump set_syncmode;
        ay1 =  20;none = ax1-ay1;if eq jump set_fmmode;
        ay1 =  21;none = ax1-ay1;if eq jump set_rotang;
        ay1 =  24;none = ax1-ay1;if eq jump set_fricaseeb;
        ay1 =  25;none = ax1-ay1;if eq jump set_oscbdetune;
        ay1 =  77;none = ax1-ay1;if eq jump set_yuk;

{xtra}  ay1 = 120;none = ax1-ay1;if eq jump all_notes_off;
        ay1 = 123;none = ax1-ay1;if eq jump all_notes_off;
{os}    ay1 =  80;none = ax1-ay1;if eq jump set_return_to_mon;

        { if controller number not matched, do nothing }

        jump end_synth_cont;

{ for these controllers, ax0 = dm(midi_val) }
set_wavea:
        dm(wavea)=ax0;

        ar  = ax0;
        sr  = lshift ar by -4 (lo);  { divide it by 16 }
        ax0 = sr0;

        ar  = ^waveforms; { get pointer to 1st waveform }
        ay0 = ax0;
        ar  = ar + ay0;
        i0  = ar;
        ax1 = dm(i0,m0);
        dm(waveforma)=ax1;

        ar  = ^waveforms; { get pointer to 2nd waveform }
        ay0 = ax0;
        ar  = ar + ay0;
        ar  = ar + 1;
        i0  = ar;
        ax1 = dm(i0,m0);
        dm(waveforma2)=ax1;

        { calculate weights for two waves }
        { ax0 still = dm(midi_val); }
        ax0 = dm(wavea);
        ay0 = 0x000f;           { use lower nybble as weight 0-15 }
        ar  = ax0 and ay0;
        sr  = lshift ar by 11(lo); { mul weight by 2048 }
        ay0 = 0x07ff;              
        ar  = sr0 or ay0;          { add 2047 }
        dm(wavemula) = ar;
        ay0 = 0x7fff;              { generate inverse weight }
        ar  = ay0 - ar;
        dm(wavemula2) = ar;

        jump end_synth_cont;

set_waveb:
        dm(waveb)=ax0;

        ar  = ax0;
        sr  = lshift ar by -4 (lo);  { divide it by 16 }
        ax0 = sr0;

        ar  = ^waveforms2;  { get pointer to first waveform }
        ay0 = ax0;
        ar  = ar + ay0;
        i0  = ar;
        ax1 = dm(i0,m0);
        dm(waveformb)=ax1;

        ar  = ^waveforms2;  { get pointer to second waveform }
        ay0 = ax0;
        ar  = ar + ay0;
        ar  = ar + 1;   
        i0  = ar;
        ax1 = dm(i0,m0);
        dm(waveformb2)=ax1;

        { calculate weights for two waves }
        { ax0 still = dm(midi_val); }
        ax0 = dm(waveb);
        ay0 = 0x000f;           { use lower nybble as weight 0-15 }
        ar  = ax0 and ay0;
        sr  = lshift ar by 11(lo); { mul weight by 2048 }
        ay0 = 0x07ff;              
        ar  = sr0 or ay0;          { add 2047 }
        dm(wavemulb) = ar;
        ay0 = 0x7fff;              { generate inverse weight }
        ar  = ay0 - ar;
        dm(wavemulb2) = ar;

        jump end_synth_cont;

set_ab_phase:
        dm(ab_phase)=ax0;

        ay0 = 0x40;   { 0<->63=phase shift 64-127=LFO }
        ar  = ax0 - ay0;
        if gt jump set_ab_phase_countdown;

set_ab_phase_shift:
        ar  = ax0;
        sr  = lshift ar by 2(lo); { multiply by four }
        dm(ab_phase_add) = sr0;

        ax0 = 0x0000;      { disable LFO }
        dm(ab_phase_LFO_enable) = ax0;
        jump end_synth_cont;

set_ab_phase_countdown:
        ay0 = ar;
        ar  = 0x003f;   { now in range 0<->63 }
        ar  = ar - ay0; { now in range 63<->0 }
        ay0 = ar;
        ar  = ar + ay0; { now in range 126<->0 }
        ay0 = 0x0001;
        ar  = ar + ay0; { now in range 127<->1 }
        dm(ab_phase_LFO_rate) = ar;
        dm(ab_phase_LFO_step) = ar;

        ax0 = 0x001b;   { 27 is magic num }
        ax0 = 0x000c;   { trying it out with faster LFO's }
        dm(ab_phase_LFO_countdown) = ax0;
        
        ax0 = 0x0001;      { enable LFO }
        dm(ab_phase_LFO_enable) = ax0;
        jump end_synth_cont;

set_bxpose1:
        dm(bxpose)=ax0;

        ay1 = dm(cur_midi_note);
        ar  = ^freqtab;
        ar  = ar + ay1;
        ay0 = 0x0018;    { lower it two octaves }
        ar  = ar - ay0;
        ay0 = dm(bxpose);  { add oscillator transpose value }
        ar  = ar + ay0;
        i0  = ar;
        ax1 = dm(i0,m0);                { get delta for that note }
        dm(wavea_delta) = ax1;            { use it }

        jump end_synth_cont;

set_bxpose2:
        dm(bxpose+1)=ax0;
        jump end_synth_cont;

set_bxpose3:
        dm(bxpose+2)=ax0;
        jump end_synth_cont;

set_bxpose4:
        dm(bxpose+4)=ax0;
        jump end_synth_cont;

set_bxpose_freq:
        dm(bxpose_freq)=ax0;
        jump end_synth_cont;

set_ab_combine_op:
        ar  = ax0;
        sr  = lshift ar by -3 (lo); { divide by 8 to give 16 diff ops }
        ax0 = sr0;

        dm(ab_combine_op)=ax0;


        jump end_synth_cont;

set_quantize:
        dm(quantize)=ax0;

        ar  = ax0;      { Generate bit reduction mask }
        sr  = lshift ar by -3 (lo); { divide by 8  to get amount of shift }
        se  = sr0;  { value from 0x0f to 0x00 }
        ar  = 0xffff;
        sr  = lshift ar(lo);        
        se  = 0;
        dm(quant_mask)= sr0;
        
        jump end_synth_cont;

set_dist_lvl:
        dm(dist_lvl)=ax0;
        jump end_synth_cont;

set_fltr_lvl:
        dm(fltr_lvl)=ax0;
        jump end_synth_cont;

set_volume:
        dm(volume)=ax0;
        ar = ax0;
        sr = lshift ar by 8(lo); { mul by 256 }
        dm(volume_mul) = sr0;
        jump end_synth_cont;

set_pan:
        dm(pan)=ax0;
        ar  = ax0;
        sr  = lshift ar by 8(lo); { mul by 256 }
        dm(left_pan) = sr0;
        ay0 = 0x7fff;     
        ar = ay0 - sr0;
        dm(right_pan) = ar;

        jump end_synth_cont;

set_inp1_lvl:
        dm(inp1_lvl)=ax0;       { save reference copy }

        ar = ax0;
        sr = lshift ar by 8(lo); { mul by 256 }
        dm(inp1_mul) = sr0;
        jump end_synth_cont;

set_inp2_lvl:
        dm(inp2_lvl)=ax0;       { save reference copy }

        ar = ax0;
        sr = lshift ar by 8(lo); { mul by 256 }
        dm(inp2_mul) = sr0;
        jump end_synth_cont;

set_syncmode:
        dm(syncmode)=ax0;      { incoming phase from 0-127  }
         
        { A resyncing B }
        dm(syncmode1)=ax0;      { value is zero or non-zero }
        ar = ax0;
        sr = lshift ar by  9(lo); { mul *2*256 }
        dm(sync_phase1)=sr0;      { outgoing from 0-65535 }

        { B resyncing A }
        ay0 = 0x40;            { look for bit 6 }
        ar  = ax0 and ay0;     
        dm(syncmode2)=ax0;     { value is zero or non-zero }

        ar = ax0;                 { in going 0-63 }
        sr = lshift ar by 10(lo); { mul *4*256 }
        dm(sync_phase2)=sr0;      { outgoing from 0-65535 }

	jump end_synth_cont;

set_fmmode:
	dm(syncmode)=ax0;
	jump end_synth_cont;

set_rotang:
        dm(rotang)=ax0;     { store it away 0-127 }

        ay0 = ax0;
        ar  = ax0+ay0;      
        dm(rotindexcos)= ar;        { 0 - 256 }
        ay0 = 0x40;                 { 64 index spots=90 degrees }
        ar  = ar + ay0;
        dm(rotindexsin)= ar;
        jump end_synth_cont;

set_lpf1:
        dm(lpf1)=ax0;

        ar  = ax0;
        sr  = lshift ar by 8(lo); { mul by 256 }
        dm(lpf1yn) = sr0;

        ay0 = 0x7fff;
        ar  = ay0 - sr0;
        dm(lpf1xn) = ar;

        jump end_synth_cont;

set_lpf2:
        dm(lpf2)=ax0;

        ar  = ax0;
        sr  = lshift ar by 8(lo); { mul by 256 }
        dm(lpf2yn) = sr0;

        ay0 = 0x7fff;
        ar = ay0 - sr0;
        dm(lpf2xn) = ar;

        jump end_synth_cont;

set_fricaseeb:  { B gets fricasee'd }
        dm(fricaseeb)=ax0;

        ar  = ax0;
        sr  = lshift ar by 6(lo); { mul by 128 }
        dm(fricbmul) = sr0;

        jump end_synth_cont;

set_oscbdetune: { De tune Oscillator B's frequency }
	  dm(oscbdetune)=ax0;

	  dm(detuneval)=mr1;
   	  jump end_synth_cont;

set_yuk:
        dm(yuk) = ax0;
        ar  = ax0;      { Generate bit reduction mask }
        sr  = lshift ar by -3 (lo); { divide by 8  to get amount of shift }
        se  = sr0;  { value from 0x0f to 0x00 }
        ar  = 0xffff;
        sr  = lshift ar(lo);        
        se  = 0;
        dm(yuk_mask)= sr0;

        rts;

set_attack:
        dm(attack)=ax0;

        ar  = ax0;      { ax0 contains control value }
        ay0 = 0x7f;
        ar  = ax0 xor ay0;      { invert it! }
        sr  = lshift ar by 4 (lo);  { multiply by 16 }

        ax1 = ^ampenv;  { save in A of ampenv }
        ay1 = 0x02;
        ar  = ax1 + ay1;
        i0  = ar;
        dm (i0,m0) = sr0;

        jump end_synth_cont;

set_decay:
        dm(decay)=ax0;

        ar  = ax0;      { ax0 contains control value }
        ay0 = 0x7f;
        ar  = ax0 xor ay0;      { invert it }
        sr  = lshift ar by 4 (lo);  { multiply by 16 }

        ax1 = ^ampenv;  { save in R of ampenv }
        ay1 = 0x03;
        ar  = ax1 + ay1;
        i0  = ar;
        dm (i0,m0) = sr0;

        jump end_synth_cont;

set_sustain:
        dm(sustain)=ax0;

        ar  = ax0;      { ax0 contains control value }
        sr  = lshift ar by 4 (lo);  { multiply by 16 }

        ax1 = ^ampenv;  { save in R of ampenv }
        ay1 = 0x04;
        ar  = ax1 + ay1;
        i0  = ar;
        dm (i0,m0) = sr0;

        jump end_synth_cont;

set_release:
        dm(release)=ax0;

        ar  = ax0;      { ax0 contains control value }
        ay0 = 0x7f;
        ar  = ax0 xor ay0;      { invert it }
        sr  = lshift ar by 4 (lo);  { multiply by 16 }

        ax1 = ^ampenv;  { save in R of ampenv }
        ay1 = 0x05;
        ar  = ax1 + ay1;
        i0  = ar;
        dm (i0,m0) = sr0;

        jump end_synth_cont;

all_notes_off:
                                        { clear VCA }
        l0  = 0;
        m0  = 1;
        i0  = ^ampenv;                  
        ax1 = 0;
        dm(i0,m0) = ax1;        { set ADSR state to Idle }

        ax1 = 0x0000;           { reset ADSR level to 0x0000 }
        dm(i0,m0) = ax1;

        rts;


set_return_to_mon:                      { if value is "off" 0-63 }
        ax1=ax0;  {dm(midi_val); }
        ay1=0x80;
        none = ax1-ay1;
        if ge rts;
                        
        ay1=0x0001;
        dm(return_to_mon)=ay1;
        rts;

end_synth_cont:
        rts;

{ transmit interrupt used for Codec initialization }
next_cmd:
        ena sec_reg;
        ax0 = dm (i3, m1);          { fetch next control word and }
        dm (tx_buf) = ax0;          { place in transmit slot 0    }
        ax0 = i3;
        ay0 = ^init_cmds;
        ar = ax0 - ay0;
        if gt rti;                  { rti if more control words still waiting }
        ax0 = 0xaf00;               { else set done flag and }
        dm (tx_buf) = ax0;          { remove MCE if done initialization }
        ax0 = 0;
        dm (stat_flag) = ax0;       { reset status flag }
        rti;

{ MIDI serial port ISR - actually just enables timer, which
  calls timer interrupt to read the serial port }
irq1isr:
        pop sts;
        ena timer;              { start timer now }
        rts;                    { note rts }

nSend:
        {rts;}
        i4 = dm (PTR_TO_OUT_CHAR);        { send int }
        call (i4);

nwt:
        ar = dm (CHAR_SEND_DONE_FLAG);
        none = pass ar;
        if eq jump nwt;                 { wait for char to go out }

        rts;

.entry      sendLine;




{******************************************************************************
 *
 *  Send null terminated string pointed to by i7 and LF/CR.  ASCII is in
 *  lower 8-bit.
 *
 *  REGISTER USAGE SUMMARY:
 *
 *  input  : i7
 *  modyfy : none
 *  output : none
 *  destroy: i7, m7 = 1, l7 = 0, ax1
 *  keep   : none
 *  memory : out_char_ax1
 *  calls  : none
 *
 ******************************************************************************}

sendLine:
        l7 = 0;
        m7 = 1;
again:
        ax1 = dm (i7, m7);
        none = pass ax1;
        if eq rts;
        call nSend;
        jump again;

        rts;

.endmod;
