

typedef unsigned char byte;


typedef struct
{
  byte l[3];
  byte t[4];
  byte lv,t1v,tk;
} Env;

typedef struct
{
  byte modsrc;
  byte freq;
  byte l[2];
  byte waveform;
  byte reset,humanize;
  byte delay;
} LFO;

typedef struct
{
  byte semitone;
  byte finetune;
  byte fmsrc[2];
  byte fcmodamt[2];
  byte waveform;
  byte enable;
  byte dcalevel;
  byte amsrc[2];
  byte amamt[2];
} Osc;

typedef struct
{
  byte am,sync,rotate,mono,envreset,oscreset;
  byte splitdir,layerflag,splitflag,splitlayerflag,cycle;
  byte dca4modamt;
  byte filterfc;
  byte q;
  byte fcsrc[2];
  byte fcmodamt[3];
  byte glide;
  byte splitpoint;
  byte layerprg,splitprg,splitlayerprg;
  byte pan,panmodsrc,panmodamt;
} Misc;

typedef struct 
{
  char filename[80];
  Env  env[4];
  LFO  lfo[3];
  Osc  osc[3];
  Misc misc;
} PCB;

// Main rendering functions
void PCB2Sysex(byte *in,byte *out);
void renderPCB(PCB *pcb,byte *buf);

// Randomizing functions
void randomizeEnv(Env *);
void randomizeLFO(LFO *);
void randomizeOsc(Osc *);
void randomizeMisc(Misc *);

void randomizeALL(PCB *);
void randomizeGroup(PCB *pcb);
void randomizeSomething(PCB *pcb);
