// Welcome to pcb.c  Shifty Death Effect done by Noah Vawter on June 25th,
// 1999.  These functions render a PCB data block for the Ensoniq ESQ-1/M
// Synthesizer from a data structure.  Then, they put that PCB block into
// sendable MIDI Sysex format.  Also included are functions to randomize
// various parts of the PCB.  Created especially for use on the Palm Pilot. 

#include "pcb.h"

void main(void)
{
  PCB thepcb,*pcbptr=&thepcb;
  byte output[210],temp[102];
  int i;

  srand(getpid());
  sprintf(pcbptr->filename,"%06d",getpid());
  randomizeALL(pcbptr);
  renderPCB(pcbptr,temp);
  PCB2Sysex(temp,output);

  for(i=0;i<210;i++)
    printf("%02c",output[i]);
}

// pass this function a rendered pcb in,
// and a pointer to a 209 byte array to out
// Then send that array out MIDI
void PCB2Sysex(byte *in,byte *out)
{
  int i,k=0;

  out[k++] = 0xf0;  // Sysex header
  out[k++] = 0x0f;  // Ensoniq ID
  out[k++] = 0x02;  // ESQ Product ID code
  out[k++] = 0x00;  // Channel 1
  out[k++] = 0x01;  // Single Program Dump Code

  for(i=0;i<102;i++)
  {  
    out[k++] = in [i]&0x0f;  // lower nybble
    out[k++] = in [i]>>4;    // upper nybble
  }
  
  out[k++] = 0xf7;  // End of Sysex
  //  printf("k is %d.\n");
}

// pass this function a valid PCB structure,
// and a 102 byte buffer for storing the rendered PCB
void renderPCB(PCB *pcb,byte *buf)
{
  int i,j,k=0;
  byte val;

  // Filename
  for(j=0;j<6;j++)
  {
    buf[k++]=pcb->filename[j];
  }

  // Once for each envelope
  for(i=0;i<4;i++)
  {
    for(j=0;j<3;j++)buf[k++]=2*pcb->env[i].l[j];   // 3 Levels
    for(j=0;j<4;j++)buf[k++]=  pcb->env[i].t[j];   // 4 Iimes
    buf[k++]=4*pcb->env[i].lv;
    buf[k++]=  pcb->env[i].t1v;
    buf[k++]=  pcb->env[i].tk;
  }
   
  // Once for each LFO
  for(i=0;i<3;i++)
  {
    buf[k++] = ((pcb->lfo[i].modsrc  &0x03)<<6) + pcb->lfo[i].freq; 
    buf[k++] = ((pcb->lfo[i].modsrc  &0x0c)<<4) + pcb->lfo[i].l[1]; 
    buf[k++] = ((pcb->lfo[i].waveform&0x03)<<6) + pcb->lfo[i].l[2]; 

    buf[k++] = ((pcb->lfo[i].reset   &0x01)<<7) + 
               ((pcb->lfo[i].humanize&0x01)<<7) +
               ( pcb->lfo[i].delay            ); 
  }

  // Once for each OSC
  for(i=0;i<3;i++)
  {
    buf[k++] = pcb->osc[i].semitone;
    buf[k++] = pcb->osc[i].finetune<<3;
    buf[k++] = (pcb->osc[i].fmsrc[1]<<4) + pcb->osc[i].fmsrc[0];
    buf[k++] = pcb->osc[i].fcmodamt[1]<<1;
    buf[k++] = pcb->osc[i].fcmodamt[0]<<1;
    buf[k++] = pcb->osc[i].waveform;
    buf[k++] = (pcb->osc[i].enable&0x01<<7)+(pcb->osc[i].dcalevel<<1);
    buf[k++] = (pcb->osc[i].amsrc[1]<<4) + pcb->osc[i].amsrc[0];
    buf[k++] = pcb->osc[i].amamt[1]<<1;
    buf[k++] = pcb->osc[i].amamt[0]<<1;
  }

  // Miscellaneous
  buf[k++] = (pcb->misc.am        <<7) + pcb->misc.dca4modamt<<1;
  buf[k++] = (pcb->misc.sync      <<7) + pcb->misc.filterfc;
  buf[k++] = (pcb->misc.q);
  buf[k++] = (pcb->misc.fcsrc[1]  <<4) + (pcb->misc.fcsrc[0]);
  buf[k++] = (pcb->misc.rotate    <<7) + pcb->misc.fcmodamt[0];
  buf[k++] = (pcb->misc.mono      <<7) + pcb->misc.fcmodamt[1];
  buf[k++] = (pcb->misc.envreset  <<7) + pcb->misc.fcmodamt[2]<<2;
  buf[k++] = (pcb->misc.oscreset  <<7) + pcb->misc.glide;
  buf[k++] = (pcb->misc.splitdir  <<7) + pcb->misc.splitpoint;
  buf[k++] = (pcb->misc.layerflag <<7) + pcb->misc.layerprg;
  buf[k++] = (pcb->misc.splitflag <<7) + pcb->misc.splitprg;
  buf[k++] = (pcb->misc.splitlayerflag<<7) + pcb->misc.splitlayerprg;
  buf[k++] = (pcb->misc.pan       <<4) + pcb->misc.panmodsrc;
  buf[k++] = (pcb->misc.cycle     <<8) + pcb->misc.panmodamt;
  //printf("k bytes written:%d.\n",k);
}    



void randomizeEnv(Env *env)
{
  int i;

  for(i=0;i<3;i++) env->l[i]=rand()%128;   // levels
  for(i=0;i<4;i++) env->t[i]=rand()%64;   // times
  env->lv  = rand()%64;
  env->t1v = rand()%64;
  env->tk  = rand()%64;
}

void randomizeLFO(LFO *lfo)
{
  lfo->modsrc = rand()%16;
  lfo->freq   = rand()%64;
  lfo->l[1]   = rand()%64;
  lfo->l[2]   = rand()%64;
  lfo->waveform = rand()%4;
  lfo->reset    = rand()%2;
  lfo->humanize = rand()%2;
  lfo->delay  = rand()%64;
}

void randomizeOsc(Osc *osc)
{
  osc->semitone = rand()%72;
  osc->finetune = rand()%32;
  osc->fmsrc[0] = rand()%16;
  osc->fmsrc[1] = rand()%16;
  osc->fcmodamt[0] = rand()%128;
  osc->fcmodamt[1] = rand()%128;
  osc->waveform    = rand()%256;
  osc->enable   = rand()%2;
  osc->dcalevel = rand()%64;
  osc->amsrc[0] = rand()%16;
  osc->amsrc[1] = rand()%16;
  osc->amamt[0] = rand()%128;
  osc->amamt[1] = rand()%128;
}

void randomizeMisc(Misc *misc)
{
  // Flags
  misc->am             = rand()%2;
  misc->sync           = rand()%2;
  misc->rotate         = rand()%2;
  misc->mono           = rand()%2;
  misc->envreset       = rand()%2;
  misc->oscreset       = rand()%2;
  misc->splitdir       = rand()%2;
  misc->layerflag      = rand()%2;
  misc->splitflag      = rand()%2;
  misc->splitlayerflag = rand()%2;
  misc->cycle          = rand()%2;

  // Values
  misc->dca4modamt     = rand()%64;
  misc->filterfc       = rand()%128;
  misc->q              = rand()%32;
  misc->fcsrc[0]       = rand()%16;
  misc->fcsrc[1]       = rand()%16;
  misc->fcmodamt[0]    = rand()%128;
  misc->fcmodamt[1]    = rand()%128;
  misc->fcmodamt[2]    = rand()%64;
  misc->glide          = rand()%64;
  misc->splitpoint     = rand()%128;
  misc->layerprg       = rand()%128;
  misc->splitprg       = rand()%128;
  misc->splitlayerprg  = rand()%128;
  misc->pan            = rand()%16;
  misc->panmodsrc      = rand()%16;
  misc->panmodamt      = rand()%128;
}

void randomizeALL(PCB *pcb)
{
  int i;

  for(i=0;i<4;i++)randomizeEnv (&pcb->env[i]);
  for(i=0;i<3;i++)randomizeLFO (&pcb->lfo[i]);
  for(i=0;i<3;i++)randomizeOsc (&pcb->osc[i]);
                  randomizeMisc(&pcb->misc);
}

// pick either env,lfo,osc or misc, and randomize one of them
void randomizeSomething(PCB *pcb)
{
  switch(rand()%4)
  {
  case 0:  randomizeEnv (&pcb->env[rand()%4]);    break;
  case 1:  randomizeLFO (&pcb->lfo[rand()%3]);    break;
  case 2:  randomizeOsc (&pcb->osc[rand()%3]);    break;
  case 3:  randomizeMisc(&pcb->misc         );    break;
  }
}

// pick either env,lfo,osc or misc, and randomize all of them in
// that group.
void randomizeGroup(PCB *pcb)
{
  int i;

  switch(rand()%4)
  {
  case 0:  for(i=0;i<4;i++)randomizeEnv (&pcb->env[i]);    break;
  case 1:  for(i=0;i<3;i++)randomizeLFO (&pcb->lfo[i]);    break;
  case 2:  for(i=0;i<3;i++)randomizeOsc (&pcb->osc[i]);    break;
  case 3:                  randomizeMisc(&pcb->misc  );    break;
  }
}
